/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

class MainWindowLayout
implements LayoutManager {
    public static final String MENUBAR_SECTION = "MENUBAR";
    public static final String TOOLBAR_SECTION = "TOOLBAR";
    public static final String CONTENT_SECTION = "CONTENT";
    public static final String STATUSBAR_SECTION = "STATUSBAR";
    private Component menubar;
    private Component toolbar;
    private Component content;
    private Component statusbar;
    private Logo logo = new Logo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (comp == null) {
            return;
        }
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null) {
                name = CONTENT_SECTION;
            }
            if (MENUBAR_SECTION.equalsIgnoreCase(name)) {
                this.menubar = comp;
            } else if (TOOLBAR_SECTION.equalsIgnoreCase(name)) {
                this.toolbar = comp;
            } else if (STATUSBAR_SECTION.equalsIgnoreCase(name)) {
                this.statusbar = comp;
            } else if (CONTENT_SECTION.equalsIgnoreCase(name)) {
                this.content = comp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            return;
        }
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (this.menubar != null && this.menubar.equals(comp)) {
                this.menubar = null;
            } else if (this.toolbar != null && this.toolbar.equals(comp)) {
                this.toolbar = null;
            } else if (this.statusbar != null && this.statusbar.equals(comp)) {
                this.statusbar = null;
            } else if (this.content != null && this.content.equals(comp)) {
                this.content = null;
            }
        }
    }

    public Component getLayoutComponent(Object constraints) {
        String name;
        String string = name = constraints == null ? null : constraints.toString();
        if (name == null || name.length() == 0) {
            return null;
        }
        if (MENUBAR_SECTION.equalsIgnoreCase(name)) {
            return this.menubar;
        }
        if (TOOLBAR_SECTION.equalsIgnoreCase(name)) {
            return this.toolbar;
        }
        if (STATUSBAR_SECTION.equalsIgnoreCase(name)) {
            return this.statusbar;
        }
        if (CONTENT_SECTION.equalsIgnoreCase(name)) {
            return this.content;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim;
            int width = 0;
            int height = 0;
            if (this.menubar != null && this.menubar.isVisible()) {
                dim = this.menubar.getMinimumSize();
                width = Math.max(dim.width, width);
                height += dim.height;
            }
            if (this.toolbar != null && this.toolbar.isVisible()) {
                dim = this.toolbar.getMinimumSize();
                width = Math.max(dim.width, width);
                height += dim.height;
            }
            if (this.statusbar != null && this.statusbar.isVisible()) {
                dim = this.statusbar.getMinimumSize();
                width = Math.max(dim.width, width);
                height += dim.height;
            }
            if (this.content != null && this.content.isVisible()) {
                dim = this.content.getMinimumSize();
                if (width == 0) {
                    width = dim.width;
                }
                height += dim.height;
            }
            Insets insets = parent.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim;
            int width = 0;
            int height = 0;
            if (this.menubar != null && this.menubar.isVisible()) {
                dim = this.menubar.getPreferredSize();
                width = Math.max(dim.width, width);
                height += dim.height;
            }
            if (this.toolbar != null && this.toolbar.isVisible()) {
                dim = this.toolbar.getPreferredSize();
                width = Math.max(dim.width, width);
                height += dim.height;
            }
            if (this.statusbar != null && this.statusbar.isVisible()) {
                dim = this.statusbar.getPreferredSize();
                width = Math.max(dim.width, width);
                height += dim.height;
            }
            if (this.content != null && this.content.isVisible()) {
                dim = this.content.getPreferredSize();
                if (width == 0) {
                    width = dim.width;
                }
                height += dim.height;
            }
            Insets insets = parent.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim;
            Insets margin = parent.getInsets();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            int x = margin.left;
            int y = margin.top;
            int w = pw - (margin.left + margin.right);
            if (this.menubar != null && this.menubar.isVisible()) {
                dim = this.menubar.getPreferredSize();
                this.menubar.setBounds(x, y, w, dim.height);
                y += dim.height;
            }
            if (this.toolbar != null && this.toolbar.isVisible()) {
                dim = this.toolbar.getPreferredSize();
                if (this.logo.getParent() == null) {
                    parent.add(this.logo);
                }
                if (this.toolbar instanceof JComponent) {
                    Border border = ((JComponent)this.toolbar).getBorder();
                    if (border == null) {
                        border = BorderFactory.createEmptyBorder();
                    }
                    this.logo.setBorder(border);
                }
                this.logo.setPreferredSize(new Dimension(100, dim.height));
                Dimension ldim = this.logo.getPreferredSize();
                int lx = pw - margin.right - ldim.width;
                int lw = lx - margin.left;
                this.toolbar.setBounds(x, y, lx - margin.right, dim.height);
                this.logo.setBounds(lx, y, ldim.width, dim.height);
                y += dim.height;
            }
            int cy = y;
            int ch = ph - margin.bottom - y;
            if (ch <= 0) {
                return;
            }
            if (this.statusbar != null && this.statusbar.isVisible()) {
                Dimension dim2 = this.statusbar.getPreferredSize();
                int y0 = ch - dim2.height + cy;
                if (y0 <= 0) {
                    return;
                }
                this.statusbar.setBounds(x, y0, w, dim2.height);
                ch = y0 - y;
            }
            if (ch <= 0) {
                return;
            }
            if (this.content != null && this.content.isVisible()) {
                Dimension dim3 = this.content.getPreferredSize();
                this.content.setBounds(x, cy, w, ch);
            }
        }
    }

    private class Logo
    extends JLabel {
        MainWindowLayout root;
        ImageIcon iicon;
        Image scaledImage;
        Dimension scale;

        Logo() {
            this.root = MainWindowLayout.this;
            try {
                URL url = this.root.getClass().getResource("icon/rameses.png");
                this.iicon = new ImageIcon(url);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setOpaque(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText("www.ramesesinc.com");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (!SwingUtilities.isLeftMouseButton(me)) {
                        return;
                    }
                    if (me.getClickCount() != 1) {
                        return;
                    }
                    try {
                        Desktop.getDesktop().browse(new URI("www.ramesesinc.com"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.iicon == null) {
                return;
            }
            Insets margin = this.getInsets();
            int w = this.getWidth();
            int h = this.getHeight();
            int x = margin.left;
            int y = margin.top;
            Image image = this.iicon.getImage();
            int imgw = this.iicon.getIconWidth();
            int imgh = this.iicon.getIconHeight();
            if (imgw < w - margin.left - margin.right) {
                x = w - (margin.left + margin.right + imgw);
            }
            if (imgh < h - margin.top - margin.bottom) {
                int rh = h - (margin.top + margin.bottom);
                y = Math.max(h / 2 - rh / 2, 0) + margin.top;
            }
            if (x < 0) {
                x = margin.left;
            }
            if (y < 0) {
                y = margin.top;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage(image, x, y, imgw, imgh, null);
            g2.dispose();
        }
    }
}

