/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.CipherUtil;
import com.rameses.osiris3.platform.ModuleEntry;
import com.rameses.osiris3.platform.UpdateConf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

final class UpdateCenterUtil {
    UpdateCenterUtil() {
    }

    private static String buildConfFileName(String appurl, String appPath) {
        File f;
        try {
            URL uRL = new URL(appurl);
        }
        catch (Exception e) {
            System.out.println("[URL-Error] " + e.getMessage());
        }
        int lastIndex = appurl.lastIndexOf("/");
        String appName = appurl.substring(appurl.lastIndexOf("/", lastIndex - 1) + 1, lastIndex);
        if (!appPath.endsWith("/")) {
            appPath = appPath + "/";
        }
        if (!(f = new File(appPath = appPath + appName)).exists()) {
            f.mkdirs();
        }
        return appPath + "/updates.sxml";
    }

    public static String buildHostPath(String appurl) {
        int lastIndex = appurl.lastIndexOf("/");
        String appName = appurl.substring(appurl.lastIndexOf("/", lastIndex - 1) + 1, lastIndex);
        return appurl.substring(0, appurl.lastIndexOf("/") + 1);
    }

    private static void persistConf(String appurl, String confFileName) throws Exception {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        InputStream is = null;
        long lastModified = 0L;
        File f = new File(confFileName);
        URLConnection uc = null;
        try {
            URL u = new URL(appurl);
            uc = u.openConnection();
            lastModified = uc.getLastModified();
            is = u.openStream();
            fos = new FileOutputStream(f);
            if (!appurl.endsWith(".sxml")) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while ((i = is.read()) != -1) {
                    sb.append((char)i);
                }
                Object o = CipherUtil.encode((Serializable)((Object)sb.toString()));
                oos = new ObjectOutputStream(fos);
                oos.writeObject(o);
                oos.flush();
            } else {
                int i = 0;
                while ((i = is.read()) != -1) {
                    fos.write((byte)i);
                }
                fos.flush();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
            UpdateCenterUtil.closeURLConnection(uc);
        }
        if (lastModified > 0L) {
            f.setLastModified(lastModified);
        }
    }

    private static void closeURLConnection(URLConnection uc) {
        try {
            if (uc instanceof HttpURLConnection) {
                ((HttpURLConnection)uc).disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static UpdateConf getUpdateConf(String appurl, String appPath) throws Exception {
        String confFileName = UpdateCenterUtil.buildConfFileName(appurl, appPath);
        File f = new File(confFileName);
        File temp = new File(confFileName + "~");
        long lastModified = -1L;
        if (f.exists()) {
            lastModified = f.lastModified();
        }
        if (lastModified < 0L) {
            UpdateCenterUtil.persistConf(appurl, confFileName);
        } else {
            try {
                URL u = new URL(appurl);
                URLConnection uc = u.openConnection();
                long modified = uc.getLastModified();
                UpdateCenterUtil.closeURLConnection(uc);
                if (modified != lastModified) {
                    UpdateCenterUtil.persistConf(appurl, confFileName);
                }
            }
            catch (Exception u) {
                // empty catch block
            }
        }
        UpdateConf uc = new UpdateConf(appurl, appPath, confFileName);
        uc.load();
        return uc;
    }

    public static List<String> getExistingFiles(String modulePath) {
        ArrayList<String> list = new ArrayList<String>();
        File dir = new File(modulePath);
        String dirPath = dir.getAbsolutePath().replace('\\', '/');
        UpdateCenterUtil.loadExistingFiles(list, dirPath, dir);
        return list;
    }

    private static void loadExistingFiles(List<String> list, String modulePath, File dir) {
        File[] files;
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                UpdateCenterUtil.loadExistingFiles(list, modulePath, file);
                continue;
            }
            String s = file.getName();
            if (!s.endsWith(".jar")) continue;
            String sname = file.getAbsolutePath().replace('\\', '/');
            if ((sname = sname.replaceFirst(modulePath, "")).startsWith("/")) {
                sname = sname.length() > 1 ? sname.substring(1) : "";
            }
            list.add(sname);
        }
    }

    public static void download(String hostPath, ModuleEntry me) throws Exception {
        URLConnection uc = null;
        InputStream is = null;
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        String filePath = me.getModulePath() + me.getFilename();
        File file = new File(filePath + ".tmp");
        boolean success = false;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            int buffSize = 32768;
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos, buffSize);
            URL u = new URL(hostPath + me.getName());
            uc = u.openConnection();
            is = uc.getInputStream();
            bis = new BufferedInputStream(is, buffSize);
            byte[] buff = new byte[buffSize];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buff)) != -1) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
            success = true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (uc instanceof HttpURLConnection) {
                try {
                    ((HttpURLConnection)uc).disconnect();
                }
                catch (Throwable throwable) {}
            }
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                bos.close();
            }
            catch (Exception exception) {}
            try {
                bis.close();
            }
            catch (Exception exception) {}
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        if (success) {
            file.renameTo(new File(filePath));
        }
    }
}

