/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.HotSpotType;
import com.topaz.sigplus.util.SigDataEventHandler;
import com.topaz.sigplus.util.SigDataPoint;
import com.topaz.sigplus.util.SigInfo;
import com.topaz.sigplus.util.SigRectangle;
import com.topaz.sigplus.util.TabletParameters;
import java.util.Vector;

public class SigDataType {
    Vector points = new Vector();
    Vector strokes = new Vector();
    Vector hotSpotList = new Vector();
    Vector hotSpotPoints = new Vector();
    SigRectangle sigWindow = new SigRectangle(0, 0, 0, 0);
    String annotation = "";
    String timeStamp = "";
    int lastPointDrawn = 0;
    int newKeyPadPoints = 0;
    SigDataEventHandler handler = null;
    boolean saveSigInfo = false;
    boolean savePressureData = false;
    boolean saveTimeData = false;

    synchronized void addNewStroke() {
        Integer strokeIdx = new Integer(this.points.size());
        this.strokes.addElement(strokeIdx);
    }

    synchronized void addNewStrokeByIndex(int index) {
        Integer strokeIdx = new Integer(index);
        this.strokes.addElement(strokeIdx);
    }

    void setLastPointDrawn(int pntIdx) {
        this.lastPointDrawn = pntIdx;
    }

    int getLastPointDrawn() {
        return this.lastPointDrawn;
    }

    public synchronized void clearSig() {
        this.points.removeAllElements();
        this.strokes.removeAllElements();
        this.hotSpotPoints.removeAllElements();
        this.newKeyPadPoints = 0;
        this.lastPointDrawn = -1;
    }

    public void setNewDataHandler(SigDataEventHandler hndlr) {
        this.handler = hndlr;
    }

    void fireIfNewData() {
        if (this.handler != null) {
            if (this.isNewData()) {
                this.handler.fireNewData();
            }
            if (this.newKeyPadPoints != 0) {
                this.handler.fireNewKeyPadData();
                this.newKeyPadPoints = 0;
            }
        }
    }

    public synchronized int getSigData(SigInfo info) {
        info.pointData = this.points;
        info.strokeData = this.strokes;
        info.numPoints = this.points.size();
        info.numStrokes = this.strokes.size();
        return this.lastPointDrawn;
    }

    boolean getPoint(int stroke, int point, SigDataPoint pnt) {
        if (stroke >= this.strokes.size()) {
            return false;
        }
        int ptIdx = (Integer)this.strokes.elementAt(stroke) + point;
        if (ptIdx >= this.points.size()) {
            return false;
        }
        pnt = (SigDataPoint)this.points.elementAt(ptIdx);
        return true;
    }

    int getNumberOfPointsInStroke(int stroke) {
        int numStrokes = this.strokes.size();
        if (stroke >= numStrokes) {
            return 0;
        }
        if (stroke == numStrokes - 1) {
            return this.points.size() - (Integer)this.strokes.elementAt(stroke);
        }
        return (Integer)this.strokes.elementAt(stroke + 1) - (Integer)this.strokes.elementAt(stroke);
    }

    synchronized int getStrokeForPoint(int pnt) {
        int pntsSoFar = 0;
        int pntsToNext = 0;
        int i = 0;
        while (i < this.strokes.size()) {
            pntsToNext = pntsSoFar + (Integer)this.strokes.elementAt(i);
            if (pnt >= pntsSoFar && pnt < pntsToNext) {
                return i;
            }
            ++i;
        }
        return i - 1;
    }

    public int totalPoints() {
        return this.points.size();
    }

    public int totalPointsClipped(TabletParameters tabParams) {
        int count = 0;
        if (!tabParams.tabletClippingMode) {
            return this.points.size();
        }
        int i = 0;
        while (i < this.points.size()) {
            SigDataPoint pnt = (SigDataPoint)this.points.elementAt(i);
            if (pnt.x > 0 && pnt.x < tabParams.tabletLogicalXSize && pnt.y > 0 && pnt.y < tabParams.tabletLogicalYSize) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean isNewData() {
        if (this.points.size() == 0) {
            return false;
        }
        return this.lastPointDrawn != this.points.size() - 1;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String newValue) {
        this.timeStamp = newValue;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String newValue) {
        this.annotation = newValue;
    }

    public void addHotSpot(TabletParameters tP, int keyCode, int coordToUse, int xPos, int yPos, int xSize, int ySize) {
        HotSpotType spot = new HotSpotType();
        if (coordToUse == 0) {
            spot.hotSpot = new SigRectangle(xPos, yPos, xSize, ySize);
        } else {
            if (tP.tabletLCDXSize == 0 || tP.tabletLCDYSize == 0) {
                return;
            }
            int x1 = this.keyPadConvertToLogical(xPos, tP.tabletLCDXSize, tP.tabletLCDXStart, tP.tabletLCDXStop);
            int y1 = this.keyPadConvertToLogical(yPos, tP.tabletLCDYSize, tP.tabletLCDYStart, tP.tabletLCDYStop);
            int x2 = this.keyPadConvertToLogical(xPos + xSize, tP.tabletLCDXSize, tP.tabletLCDXStart, tP.tabletLCDXStop);
            int y2 = this.keyPadConvertToLogical(yPos + ySize, tP.tabletLCDYSize, tP.tabletLCDYStart, tP.tabletLCDYStop);
            spot.hotSpot = new SigRectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        }
        spot.hotSpotCode = keyCode;
        this.hotSpotList.addElement(spot);
    }

    public void clearHotSpotList() {
        this.hotSpotList.removeAllElements();
    }

    public void setSigWindow(TabletParameters tP, int coordToUse, int xPos, int yPos, int xSize, int ySize) {
        if (coordToUse == 0) {
            this.sigWindow = new SigRectangle(xPos, yPos, xSize, ySize);
        } else {
            if (tP.tabletLCDXSize == 0 || tP.tabletLCDYSize == 0) {
                return;
            }
            int x1 = this.keyPadConvertToLogical(xPos, tP.tabletLCDXSize, tP.tabletLCDXStart, tP.tabletLCDXStop);
            int y1 = this.keyPadConvertToLogical(yPos, tP.tabletLCDYSize, tP.tabletLCDYStart, tP.tabletLCDYStop);
            int x2 = this.keyPadConvertToLogical(xPos + xSize, tP.tabletLCDXSize, tP.tabletLCDXStart, tP.tabletLCDXStop);
            int y2 = this.keyPadConvertToLogical(yPos + ySize, tP.tabletLCDYSize, tP.tabletLCDYStart, tP.tabletLCDYStop);
            this.sigWindow = new SigRectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        }
    }

    public void clearSigWindow(int inside) {
        if (inside == 0) {
            this.points.removeAllElements();
            this.strokes.removeAllElements();
            this.lastPointDrawn = -1;
        } else {
            this.hotSpotPoints.removeAllElements();
        }
    }

    public void clearHotSpotPoints() {
        this.hotSpotPoints.removeAllElements();
    }

    public int queryHotSpot(int keyCode) {
        int count = 0;
        int i = 0;
        while (i < this.hotSpotList.size()) {
            HotSpotType spot = (HotSpotType)this.hotSpotList.elementAt(i);
            if (spot.hotSpotCode == keyCode) {
                SigDataPoint pnt;
                int j = 0;
                while (j < this.points.size()) {
                    pnt = (SigDataPoint)this.points.elementAt(j);
                    if (spot.hotSpot.contains(pnt.x, pnt.y)) {
                        ++count;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.hotSpotPoints.size()) {
                    pnt = (SigDataPoint)this.hotSpotPoints.elementAt(j);
                    if (spot.hotSpot.contains(pnt.x, pnt.y)) {
                        ++count;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return count;
    }

    public int keyPadConvertToLogical(int lcdPos, int lcdSize, int lcdStart, int lcdStop) {
        if (lcdSize == 0) {
            return lcdPos;
        }
        int pos = lcdPos;
        pos *= lcdStop - lcdStart;
        pos /= lcdSize;
        return pos += lcdStart;
    }

    public boolean getSaveSigInfo() {
        return this.saveSigInfo;
    }

    public boolean isInSigWindow(int x, int y) {
        return this.sigWindow.width > 0 && this.sigWindow.contains(x, y);
    }

    public void setSaveSigInfo(boolean trueToSave) {
        this.saveSigInfo = trueToSave;
    }

    public boolean addHotSpotPoint(int x, int y, long p) {
        SigDataPoint point = new SigDataPoint(x, y, p);
        if (this.sigWindow.width > 0 && !this.sigWindow.contains(point.x, point.y)) {
            this.hotSpotPoints.addElement(point);
            ++this.newKeyPadPoints;
            return true;
        }
        return false;
    }

    synchronized void addNewPoint(int newX, int newY, long newP) {
        SigDataPoint pt = new SigDataPoint(newX, newY, newP);
        this.points.addElement(pt);
    }

    public boolean getSavePressureData() {
        return this.savePressureData;
    }

    public boolean getSaveTimeData() {
        return this.saveTimeData;
    }

    public void setSavePressureData(boolean state) {
        this.savePressureData = state;
    }

    public void setSaveTimeData(boolean state) {
        this.saveTimeData = state;
    }
}

