/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class AcrylScrollBarUI
extends BaseScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new AcrylScrollBarUI();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        Color[] colors = this.getThumbColors();
        Color frameColor = AbstractLookAndFeel.getFrameColor();
        if (!JTattooUtilities.isActive(this.scrollbar)) {
            frameColor = ColorHelper.brighter(frameColor, 80.0);
        }
        if (this.isRollover || this.isDragging) {
            frameColor = AbstractLookAndFeel.getTheme().getRolloverColorDark();
        }
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g, frameColor, ColorHelper.darker(frameColor, 15.0), 0, 0, thumbBounds.width, thumbBounds.height);
            Graphics2D g2D = (Graphics2D)g;
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            if (!AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
                int dx = 5;
                int dy = thumbBounds.height / 2 - 3;
                int dw = thumbBounds.width - 11;
                Color c1 = Color.white;
                Color c2 = Color.darkGray;
                for (int i = 0; i < 4; ++i) {
                    g.setColor(c1);
                    g.drawLine(dx, dy, dx + dw, dy);
                    g.setColor(c2);
                    g.drawLine(dx, ++dy, dx + dw, dy);
                    ++dy;
                }
            }
            g2D.setComposite(composite);
        } else {
            JTattooUtilities.fillHorGradient(g, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g, frameColor, ColorHelper.darker(frameColor, 10.0), 0, 0, thumbBounds.width, thumbBounds.height);
            int dx = thumbBounds.width / 2 - 3;
            int dy = 5;
            int dh = thumbBounds.height - 11;
            Graphics2D g2D = (Graphics2D)g;
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            if (!AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
                Color c1 = Color.white;
                Color c2 = Color.darkGray;
                for (int i = 0; i < 4; ++i) {
                    g.setColor(c1);
                    g.drawLine(dx, dy, dx, dy + dh);
                    g.setColor(c2);
                    g.drawLine(++dx, dy, dx, dy + dh);
                    ++dx;
                }
            }
            g2D.setComposite(composite);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

