/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.w3c.dom.Element;

public abstract class NamespaceHandlerSupport
implements NamespaceHandler {
    private final Map parsers = new HashMap();
    private final Map decorators = new HashMap();

    public final BeanDefinitionParser findParserForElement(Element element) {
        BeanDefinitionParser parser = (BeanDefinitionParser)this.parsers.get(element.getLocalName());
        if (parser == null) {
            throw new IllegalArgumentException("Cannot locate BeanDefinitionParser for element [" + element.getLocalName() + "].");
        }
        return parser;
    }

    public final BeanDefinitionDecorator findDecoratorForElement(Element element) {
        BeanDefinitionDecorator decorator = (BeanDefinitionDecorator)this.decorators.get(element.getLocalName());
        if (decorator == null) {
            throw new IllegalArgumentException("Cannot locate BeanDefinitionDecorator for element [" + element.getLocalName() + "].");
        }
        return decorator;
    }

    protected void registerBeanDefinitionParser(String elementName, BeanDefinitionParser parser) {
        this.parsers.put(elementName, parser);
    }

    protected void registerBeanDefinitionDecorator(String elementName, BeanDefinitionDecorator decorator) {
        this.decorators.put(elementName, decorator);
    }
}

