/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.util.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JDBCConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private JButton jButtonWizard;
    private JCheckBox jCheckBoxSavePassword;
    private JComboBox jComboBoxJDBCDriver;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JPanel jPanelJDBC;
    private JTextField jTextFieldDBName;
    private JTextField jTextFieldJDBCUrl;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldServerAddress;
    private JTextField jTextFieldUsername;

    public JDBCConnectionEditor() {
        this.initComponents();
        this.applyI18n();
        this.jComboBoxJDBCDriver.setModel(new DefaultComboBoxModel<Object>(new Object[]{"COM.cloudscape.JDBCDriver", "COM.ibm.db2.jdbc.app.DB2Driver", "com.inet.tds.TdsDriver", "com.informix.jdbc.IfxDriver", "com.ingres.jdbc.IngresDriver", "com.internetcds.jdbc.tds.Driver", "com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "com.ms.jdbc.odbc.JdbcOdbcDriver", "com.mysql.jdbc.Driver", "com.sybase.jdbc2.jdbc.SybDriver", "net.sourceforge.jtds.jdbc.Driver", "oracle.jdbc.driver.OracleDriver", "org.gjt.mm.mysql.Driver", "org.hsqldb.jdbcDriver", "org.postgresql.Driver", "sun.jdbc.odbc.JdbcOdbcDriver", "org.sqlite.JDBC"}));
        this.jComboBoxJDBCDriver.setSelectedItem("com.mysql.jdbc.Driver");
    }

    private void initComponents() {
        this.jPanelJDBC = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxJDBCDriver = new JComboBox();
        this.jTextFieldJDBCUrl = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldDBName = new JTextField();
        this.jTextFieldServerAddress = new JTextField();
        this.jButtonWizard = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextFieldPassword = new JPasswordField();
        this.jTextFieldUsername = new JTextField();
        this.jCheckBoxSavePassword = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelJDBC.setLayout(new GridBagLayout());
        this.jLabel2.setText("JDBC Driver");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("JDBC URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel3, gridBagConstraints);
        this.jComboBoxJDBCDriver.setEditable(true);
        this.jComboBoxJDBCDriver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDBCConnectionEditor.this.jComboBoxJDBCDriverActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jComboBoxJDBCDriver, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jTextFieldJDBCUrl, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("JDBC URL Wizard"));
        this.jPanel2.setMinimumSize(new Dimension(179, 70));
        this.jLabel14.setText("Server Address");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel5.setText("Database");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jTextFieldDBName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jTextFieldServerAddress, gridBagConstraints);
        this.jButtonWizard.setText("Wizard");
        this.jButtonWizard.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonWizard.setMaximumSize(new Dimension(60, 23));
        this.jButtonWizard.setMinimumSize(new Dimension(60, 23));
        this.jButtonWizard.setPreferredSize(new Dimension(60, 23));
        this.jButtonWizard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDBCConnectionEditor.this.jButtonWizardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.jPanel2.add((Component)this.jButtonWizard, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelJDBC.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel6.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextFieldPassword.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jTextFieldPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jCheckBoxSavePassword.setText("Save password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jCheckBoxSavePassword, gridBagConstraints);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/problems/warning.png")));
        this.jLabel1.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelJDBC.add((Component)this.jLabel1, gridBagConstraints);
        this.add((Component)this.jPanelJDBC, "Center");
    }

    private void jComboBoxJDBCDriverActionPerformed(ActionEvent evt) {
        this.jButtonWizardActionPerformed(null);
    }

    private void jButtonWizardActionPerformed(ActionEvent evt) {
        if (this.jComboBoxJDBCDriver.getSelectedIndex() < 0) {
            return;
        }
        String driver = "" + this.jComboBoxJDBCDriver.getSelectedItem();
        if ((driver = driver.trim()).equals("")) {
            return;
        }
        String server = this.jTextFieldServerAddress.getText().trim();
        if (server.length() == 0) {
            server = "localhost";
        }
        String databaseName = this.jTextFieldDBName.getText().trim();
        if (driver.equalsIgnoreCase("org.gjt.mm.mysql.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.internetcds.jdbc.tds.Driver")) {
            String url = "jdbc:freetds:sqlserver://localhost/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:microsoft:sqlserver://" + server + ":1433;DatabaseName=";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            url = databaseName.length() > 0 ? url + this.jTextFieldDBName.getText() : url + "DSNAME";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.ms.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            url = databaseName.length() > 0 ? url + databaseName : url + "DSNAME";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("oracle.jdbc.driver.OracleDriver")) {
            String url = "jdbc:oracle:thin:@" + server + ":1521:";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("COM.ibm.db2.jdbc.app.DB2Driver")) {
            String url = "jdbc:db2:";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.informix.jdbc.IfxDriver")) {
            String url = "jdbc:informix-sqli://" + server + ":port/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            url = url + ":informixserver=SERVERNAME";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.sybase.jdbc2.jdbc.SybDriver")) {
            String url = "jdbc:sybase:Tds:" + server + ":2638/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:sqlserver://" + server + ":1433/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.microsoft.sqlserver.jdbc.SQLServerDriver")) {
            String url = "jdbc:sqlserver://" + server + ":1433;DatabaseName=";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.inet.tds.TdsDriver")) {
            String url = "jdbc:inetdae7:" + server + ":1433/";
            url = databaseName.length() > 0 ? url + this.jTextFieldDBName.getText() : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("org.postgresql.Driver")) {
            String url = "jdbc:postgresql://" + server + ":5432/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("org.hsqldb.jdbcDriver")) {
            String url = "jdbc:hsqldb:[PATH_TO_DB_FILES]/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("COM.cloudscape.JDBCDriver ")) {
            String url = "jdbc:cloudscape:/cloudscape/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("net.sourceforge.jtds.jdbc.Driver")) {
            String url = "jdbc:jtds:sqlserver://" + server + "/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            url = url + ";instance=";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("com.ingres.jdbc.IngresDriver")) {
            String url = "jdbc:ingres://" + server + ":II7/";
            url = databaseName.length() > 0 ? url + databaseName : url + "MYDATABASE";
            this.jTextFieldJDBCUrl.setText(url);
        } else if (driver.equalsIgnoreCase("org.sqlite.JDBC")) {
            String url = "jdbc:sqlite:";
            url = databaseName.length() > 0 ? url + databaseName : url + "filename";
            this.jTextFieldJDBCUrl.setText(url);
        }
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JDBCConnection) {
            JDBCConnection con = (JDBCConnection)this.iReportConnection;
            this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            this.jTextFieldJDBCUrl.setText(con.getUrl());
            this.jTextFieldServerAddress.setText(con.getServerAddress());
            this.jTextFieldDBName.setText(con.getDatabase());
            this.jTextFieldUsername.setText(con.getUsername());
            if (con.isSavePassword()) {
                this.jTextFieldPassword.setText(con.getPassword());
            } else {
                this.jTextFieldPassword.setText("");
            }
            this.jCheckBoxSavePassword.setSelected(con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        JDBCConnection irConn = new JDBCConnection();
        irConn.setServerAddress(this.jTextFieldServerAddress.getText().trim());
        irConn.setDatabase(this.jTextFieldDBName.getText().trim());
        irConn.setUsername(this.jTextFieldUsername.getText().trim());
        if (this.jCheckBoxSavePassword.isSelected()) {
            irConn.setPassword(new String(this.jTextFieldPassword.getPassword()));
        } else {
            irConn.setPassword("");
        }
        irConn.setSavePassword(this.jCheckBoxSavePassword.isSelected());
        irConn.setJDBCDriver((this.jComboBoxJDBCDriver.getSelectedItem() + "").trim());
        if ((this.jComboBoxJDBCDriver.getSelectedItem() + "").trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.connectionDialog.jdbc.invalidDriver", "Please insert a valid JDBC driver!"), I18n.getString("messages.connectionDialog.jdbc.invalidDriverCaption", "Invalid driver!"), 2);
            return null;
        }
        if (this.jTextFieldJDBCUrl.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.connectionDialog.jdbc.invalidUrl", "Please insert a valid JDBC URL!"), I18n.getString("messages.connectionDialog.jdbc.invalidUrlCaption", "Invalid url!"), 2);
            return null;
        }
        irConn.setUrl(this.jTextFieldJDBCUrl.getText().trim());
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    public void applyI18n() {
        this.jCheckBoxSavePassword.setText(I18n.getString("connectionDialog.checkBoxSavePassword", "Save password"));
        this.jButtonWizard.setText(I18n.getString("connectionDialog.buttonWizard", "Wizard"));
        this.jLabel14.setText(I18n.getString("connectionDialog.label14", "Server Address"));
        this.jLabel2.setText(I18n.getString("connectionDialog.label2", "JDBC Driver"));
        this.jLabel3.setText(I18n.getString("connectionDialog.label3", "JDBC URL"));
        this.jLabel5.setText(I18n.getString("connectionDialog.label5", "Database"));
        this.jLabel6.setText(I18n.getString("connectionDialog.label6", "Username"));
        this.jLabel7.setText(I18n.getString("connectionDialog.label7", "Password"));
        ((TitledBorder)this.jPanel2.getBorder()).setTitle(I18n.getString("connectionDialog.panelBorder.jdbcUrlWizard", "JDBC URL Wizard"));
        this.jLabel1.setText("<html>" + I18n.getString("connectionDialog.textArea1", "ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it."));
    }
}

