/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.ReportBandSheetPanel;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRGroupDialog
extends JDialog {
    private String groupName;
    private String expression;
    private int minHeightStartNewPage = 0;
    private int headerBandHeight = 0;
    private int footerBandHeight = 0;
    private boolean startNewPage = false;
    private boolean startNewColumn = false;
    private boolean printHeaderEachPage = false;
    private boolean resetPageNumber = false;
    private SubDataset subdataset = null;
    private Group cachedGroup = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxPrintHeaderEachPage;
    private JCheckBox jCheckBoxResetPageNumber;
    private JCheckBox jCheckBoxStartNewColumn;
    private JCheckBox jCheckBoxStartNewPage;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JNumberField jNumberFieldFooterBand;
    private JNumberField jNumberFieldHeaderBand;
    private JNumberField jNumberFieldMinStartNewPage;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionArea;
    private JTextField jTextFieldName;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_GROUP_EXPRESSION = 1;

    public JRGroupDialog(JDialog dialog, boolean modal) {
        super((Dialog)dialog, modal);
        this.initAll();
    }

    public JRGroupDialog(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.applyI18n();
        this.jRTextExpressionArea.setText("");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRGroupDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.pack();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jCheckBoxStartNewColumn = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.jCheckBoxStartNewPage = new JCheckBox();
        this.jCheckBoxResetPageNumber = new JCheckBox();
        this.jCheckBoxPrintHeaderEachPage = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jNumberFieldMinStartNewPage = new JNumberField();
        this.jLabel6 = new JLabel();
        this.jNumberFieldHeaderBand = new JNumberField();
        this.jLabel7 = new JLabel();
        this.jNumberFieldFooterBand = new JNumberField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify group");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRGroupDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Group name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jCheckBoxStartNewColumn.setText("Start on a new column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jCheckBoxStartNewColumn, gridBagConstraints);
        this.jLabel3.setText("Group expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionArea.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionArea.setPreferredSize(new Dimension(300, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionArea, gridBagConstraints);
        this.jCheckBoxStartNewPage.setText("Start on a new page");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jCheckBoxStartNewPage, gridBagConstraints);
        this.jCheckBoxResetPageNumber.setText("Reset page number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jCheckBoxResetPageNumber, gridBagConstraints);
        this.jCheckBoxPrintHeaderEachPage.setText("Print header on each page");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jCheckBoxPrintHeaderEachPage, gridBagConstraints);
        this.jLabel5.setText("Min height to start new page");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jNumberFieldMinStartNewPage.setColumns(4);
        this.jNumberFieldMinStartNewPage.setHorizontalAlignment(4);
        try {
            this.jNumberFieldMinStartNewPage.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jNumberFieldMinStartNewPage, gridBagConstraints);
        this.jLabel6.setText("Group header band height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jNumberFieldHeaderBand.setColumns(4);
        this.jNumberFieldHeaderBand.setHorizontalAlignment(4);
        try {
            this.jNumberFieldHeaderBand.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldHeaderBand.setValue(50.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jNumberFieldHeaderBand, gridBagConstraints);
        this.jLabel7.setText("Group footer band height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jNumberFieldFooterBand.setColumns(4);
        this.jNumberFieldFooterBand.setHorizontalAlignment(4);
        try {
            this.jNumberFieldFooterBand.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldFooterBand.setValue(50.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jNumberFieldFooterBand, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRGroupDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRGroupDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String proposed_name;
        SubDataset sd = this.getSubdataset();
        if (sd == null) {
            sd = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        }
        if ((proposed_name = this.jTextFieldName.getText().trim()).length() <= 0 || proposed_name.equals("page") || proposed_name.equals("column") || proposed_name.equals("lastPage")) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRGroupDialog.notValidGroupName", "Please insert a valid group name!"), I18n.getString("messages.jRGroupDialog.notValidGroupNameCaption", "Invalid name!"), 2);
            return;
        }
        if (!ReportBandSheetPanel.isValidGroupName(sd, this.cachedGroup, this.jTextFieldName.getText().trim())) {
            JOptionPane.showMessageDialog(this, I18n.getString("reportGroupWizard.jLabelErrorMessage", "This group name is already in use."), I18n.getString("messages.jRGroupDialog.notValidGroupNameCaption", "Invalid name!"), 2);
            return;
        }
        this.setGroupName(this.jTextFieldName.getText());
        this.setHeaderBandHeight((int)this.jNumberFieldHeaderBand.getValue());
        this.setFooterBandHeight((int)this.jNumberFieldFooterBand.getValue());
        this.setMinHeightStartNewPage((int)this.jNumberFieldMinStartNewPage.getValue());
        this.setStartNewColumn(this.jCheckBoxStartNewColumn.isSelected());
        this.setStartNewPage(this.jCheckBoxStartNewPage.isSelected());
        this.setPrintHeaderEachPage(this.jCheckBoxPrintHeaderEachPage.isSelected());
        this.setResetPageNumber(this.jCheckBoxResetPageNumber.isSelected());
        this.setExpression(this.jRTextExpressionArea.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public void setGroup(Group group) {
        this.cachedGroup = group;
        this.jTextFieldName.setText(new String(group.getName()));
        this.jCheckBoxStartNewPage.setSelected(group.isIsStartNewPage());
        this.jCheckBoxStartNewColumn.setSelected(group.isIsStartNewColumn());
        this.jCheckBoxPrintHeaderEachPage.setSelected(group.isIsReprintHeaderOnEachPage());
        this.jCheckBoxResetPageNumber.setSelected(group.isIsResetPageNumber());
        this.jRTextExpressionArea.setText(new String(group.getGroupExpression().trim()));
        try {
            this.jNumberFieldMinStartNewPage.setValue(group.getMinHeightToStartNewPage());
            this.jNumberFieldHeaderBand.setValue(group.getGroupHeader().getHeight());
            this.jNumberFieldFooterBand.setValue(group.getGroupFooter().getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getFooterBandHeight() {
        return this.footerBandHeight;
    }

    public void setFooterBandHeight(int footerBandHeight) {
        this.footerBandHeight = footerBandHeight;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getHeaderBandHeight() {
        return this.headerBandHeight;
    }

    public void setHeaderBandHeight(int headerBandHeight) {
        this.headerBandHeight = headerBandHeight;
    }

    public int getMinHeightStartNewPage() {
        return this.minHeightStartNewPage;
    }

    public void setMinHeightStartNewPage(int minHeightStartNewPage) {
        this.minHeightStartNewPage = minHeightStartNewPage;
    }

    public boolean isPrintHeaderEachPage() {
        return this.printHeaderEachPage;
    }

    public void setPrintHeaderEachPage(boolean printHeaderEachPage) {
        this.printHeaderEachPage = printHeaderEachPage;
    }

    public boolean isResetPageNumber() {
        return this.resetPageNumber;
    }

    public void setResetPageNumber(boolean resetPageNumber) {
        this.resetPageNumber = resetPageNumber;
    }

    public boolean isStartNewColumn() {
        return this.startNewColumn;
    }

    public void setStartNewColumn(boolean startNewColumn) {
        this.startNewColumn = startNewColumn;
    }

    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    public void setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }

    public void applyI18n() {
        this.jCheckBoxPrintHeaderEachPage.setText(I18n.getString("jRGroupDialog.checkBoxPrintHeaderEachPage", "Print header on each page"));
        this.jCheckBoxResetPageNumber.setText(I18n.getString("jRGroupDialog.checkBoxResetPageNumber", "Reset page number"));
        this.jCheckBoxStartNewColumn.setText(I18n.getString("jRGroupDialog.checkBoxStartNewColumn", "Start on a new column"));
        this.jCheckBoxStartNewPage.setText(I18n.getString("jRGroupDialog.checkBoxStartNewPage", "Start on a new page"));
        this.jButtonCancel.setText(I18n.getString("jRGroupDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRGroupDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("jRGroupDialog.label1", "Group name"));
        this.jLabel3.setText(I18n.getString("jRGroupDialog.label3", "Group expression"));
        this.jLabel5.setText(I18n.getString("jRGroupDialog.label5", "Min height to start new page"));
        this.jLabel6.setText(I18n.getString("jRGroupDialog.label6", "Group header band height"));
        this.jLabel7.setText(I18n.getString("jRGroupDialog.label7", "Group footer band height"));
        this.setTitle(I18n.getString("jRGroupDialog.title", "Add/modify group"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRGroupDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("jRGroupDialog.buttonOKMnemonic", "o").charAt(0));
    }

    public SubDataset getSubdataset() {
        return this.subdataset;
    }

    public void setSubdataset(SubDataset subdataset) {
        this.subdataset = subdataset;
        this.jRTextExpressionArea.setSubDataset(this.getSubdataset());
    }

    public void setFocusedExpression(int expID) {
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionArea);
            }
        }
    }
}

