/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.subdataset;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.DatasetPropertiesDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportQueryDialog;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.gui.subdataset.GroupsDialog;
import it.businesslogic.ireport.gui.subdataset.SubDatasetsDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SubDatasetDialog
extends JDialog {
    private SubDataset subDataset = null;
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonFields;
    private JButton jButtonGroups;
    private JButton jButtonOk;
    private JButton jButtonParameters;
    private JButton jButtonProperties;
    private JButton jButtonQuery;
    private JButton jButtonVariables;
    private JComboBox jComboBoxWhenResourceMissingType;
    private JLabel jLabel1;
    private JLabel jLabelName;
    private JLabel jLabelResourceBoundle;
    private JLabel jLabelScriptletClass;
    private JLabel jLabelScriptletClass1;
    private JLabel jLabelWhenResourceMissingType;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JRTextExpressionArea jRTextExpressionAreaFilterExpression;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldName;
    private JTextField jTextFieldResourceBoundle;
    private JTextField jTextFieldScriptletClass;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_FILTER_EXPRESSION = 1;
    public static final int COMPONENT_SCRIPTLET_EXPRESSION = 2;
    public static final int COMPONENT_DATASET_NAME = 3;
    public static final int COMPONENT_RESOURCE_BUNDLE = 4;

    public SubDatasetDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.afterInit();
    }

    public SubDatasetDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.afterInit();
    }

    public void afterInit() {
        this.pack();
        Misc.centerFrame(this);
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Null", I18n.getString("whenResourceMissingType.Null", "Null")));
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Empty", I18n.getString("whenResourceMissingType.Empty", "Empty")));
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Key", I18n.getString("whenResourceMissingType.Key", "Key")));
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Error", I18n.getString("whenResourceMissingType.Error", "Error")));
        this.applyI18n();
        Misc.setComboboxSelectedTagValue(this.jComboBoxWhenResourceMissingType, "Null");
        boolean found = true;
        int i = 1;
        while (found) {
            found = false;
            Enumeration e = MainFrame.getMainInstance().getActiveReportFrame().getReport().getSubDatasets().elements();
            while (e.hasMoreElements() && !found) {
                SubDataset dataset = (SubDataset)e.nextElement();
                if (!dataset.getName().equals("SubDataset" + i)) continue;
                found = true;
            }
            if (!found) {
                this.jTextFieldName.setText("SubDataset" + i);
            }
            ++i;
        }
        this.jTextFieldResourceBoundle.setText(MainFrame.getMainInstance().getActiveReportFrame().getReport().getResourceBundleBaseName());
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelResourceBoundle = new JLabel();
        this.jTextFieldResourceBoundle = new JTextField();
        this.jLabelScriptletClass = new JLabel();
        this.jTextFieldScriptletClass = new JTextField();
        this.jLabelWhenResourceMissingType = new JLabel();
        this.jComboBoxWhenResourceMissingType = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelScriptletClass1 = new JLabel();
        this.jRTextExpressionAreaFilterExpression = new JRTextExpressionArea();
        this.jPanel1 = new JPanel();
        this.jButtonFields = new JButton();
        this.jButtonVariables = new JButton();
        this.jButtonParameters = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonQuery = new JButton();
        this.jButtonGroups = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonProperties = new JButton();
        this.jPanel6 = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("SubDataset");
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Subdataset properties", 0, 0, new Font("Dialog", 0, 11)));
        this.jLabelName.setHorizontalAlignment(4);
        this.jLabelName.setText("Datasource name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanel4.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel4.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabelResourceBoundle.setHorizontalAlignment(4);
        this.jLabelResourceBoundle.setText("Resource Boundle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(16, 4, 0, 0);
        this.jPanel4.add((Component)this.jLabelResourceBoundle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 4, 4, 4);
        this.jPanel4.add((Component)this.jTextFieldResourceBoundle, gridBagConstraints);
        this.jLabelScriptletClass.setHorizontalAlignment(4);
        this.jLabelScriptletClass.setText("Scriptlet class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(16, 4, 4, 0);
        this.jPanel4.add((Component)this.jLabelScriptletClass, gridBagConstraints);
        this.jTextFieldScriptletClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jTextFieldScriptletClassActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 4, 4, 4);
        this.jPanel4.add((Component)this.jTextFieldScriptletClass, gridBagConstraints);
        this.jLabelWhenResourceMissingType.setHorizontalAlignment(4);
        this.jLabelWhenResourceMissingType.setText("When resource missing type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanel4.add((Component)this.jLabelWhenResourceMissingType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel4.add((Component)this.jComboBoxWhenResourceMissingType, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/subdatasource.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jButtonOk.setText("Create");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabelScriptletClass1.setHorizontalAlignment(4);
        this.jLabelScriptletClass1.setText("Filter expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 4, 4, 0);
        this.jPanel4.add((Component)this.jLabelScriptletClass1, gridBagConstraints);
        this.jLabelScriptletClass1.getAccessibleContext().setAccessibleName("Filter expression");
        this.jRTextExpressionAreaFilterExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaFilterExpression.setCaretVisible(false);
        this.jRTextExpressionAreaFilterExpression.setElectricScroll(0);
        this.jRTextExpressionAreaFilterExpression.setMinimumSize(new Dimension(657, 50));
        this.jRTextExpressionAreaFilterExpression.setPreferredSize(new Dimension(325, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel4.add((Component)this.jRTextExpressionAreaFilterExpression, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        this.jButtonFields.setText("Fields");
        this.jButtonFields.setEnabled(false);
        this.jButtonFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonFieldsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonFields, gridBagConstraints);
        this.jButtonVariables.setText("Variables");
        this.jButtonVariables.setEnabled(false);
        this.jButtonVariables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonVariablesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonVariables, gridBagConstraints);
        this.jButtonParameters.setText("Parameters");
        this.jButtonParameters.setEnabled(false);
        this.jButtonParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonParametersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonParameters, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        this.jSeparator1.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jButtonQuery.setText("Query");
        this.jButtonQuery.setEnabled(false);
        this.jButtonQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonQuery, gridBagConstraints);
        this.jButtonGroups.setText("Groups");
        this.jButtonGroups.setEnabled(false);
        this.jButtonGroups.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonGroupsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonGroups, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        this.jSeparator2.setPreferredSize(new Dimension(2, 2));
        this.jSeparator2.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jSeparator2, gridBagConstraints);
        this.jButtonProperties.setText("Properties");
        this.jButtonProperties.setEnabled(false);
        this.jButtonProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubDatasetDialog.this.jButtonParametersActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonProperties, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 6, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jTextFieldScriptletClassActionPerformed(ActionEvent evt) {
    }

    private void jButtonParametersActionPerformed1(ActionEvent evt) {
        DatasetPropertiesDialog pd = new DatasetPropertiesDialog((Dialog)this, true);
        pd.setDataset(this.getSubDataset());
        pd.updateProperties();
        pd.setVisible(true);
    }

    private void jButtonGroupsActionPerformed(ActionEvent evt) {
        GroupsDialog grd = new GroupsDialog((Dialog)this, true);
        grd.setSubDataset(this.getSubDataset());
        grd.setVisible(true);
    }

    private void jButtonQueryActionPerformed(ActionEvent evt) {
        ReportQueryDialog rqd = new ReportQueryDialog((Frame)MainFrame.getMainInstance(), true);
        rqd.setSubDataset(this.getSubDataset());
        rqd.setVisible(true);
        this.jRTextExpressionAreaFilterExpression.setText(rqd.getSubDataset().getFilterExpression());
    }

    private void jButtonParametersActionPerformed(ActionEvent evt) {
        this.openValuesDialog("Parameters");
    }

    private void jButtonVariablesActionPerformed(ActionEvent evt) {
        this.openValuesDialog("Variables");
    }

    private void jButtonFieldsActionPerformed(ActionEvent evt) {
        this.openValuesDialog("Fields");
    }

    public void openValuesDialog(String tab) {
        ValuesDialog vd = new ValuesDialog((Dialog)this, true);
        vd.getValuesPanel().setSubDataset(this.getSubDataset());
        vd.setTitle(this.getSubDataset() + ": values");
        vd.getValuesPanel().gotoTab(tab);
        this.getSubDataset().addSubDatasetObjectChangedListener(vd);
        vd.setVisible(true);
        this.getSubDataset().removeSubDatasetObjectChangedListener(vd);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.subDatasetDialog.notValidName", "Please insert a valid SubDataset name!"), I18n.getString("messages.subDatasetDialog.notValidNameCaption", "Invalid name!"), 2);
            return;
        }
        String newName = this.jTextFieldName.getText().trim();
        Enumeration e = MainFrame.getMainInstance().getActiveReportFrame().getReport().getSubDatasets().elements();
        while (e.hasMoreElements()) {
            SubDataset dataset = (SubDataset)e.nextElement();
            if (!dataset.getName().equals(newName) || dataset == this.getSubDataset()) continue;
            JOptionPane.showMessageDialog(this, I18n.getFormattedString("messages.subDatasetDialog.nameAlreadyInUse", "The name \"{0}\" is already in use!\nPlease change it.", new Object[]{newName}), I18n.getString("messages.subDatasetDialog.notValidNameCaption", "Invalid name!"), 2);
            return;
        }
        if (this.getSubDataset() == null) {
            this.subDataset = new SubDataset();
        }
        SubDataset subdataset = this.getSubDataset();
        subdataset.setName(this.jTextFieldName.getText());
        subdataset.setScriptletClass(this.jTextFieldScriptletClass.getText());
        subdataset.setResourceBundleBaseName(this.jTextFieldResourceBoundle.getText());
        subdataset.setFilterExpression(this.jRTextExpressionAreaFilterExpression.getText());
        if (this.jComboBoxWhenResourceMissingType.getSelectedItem() != null) {
            Tag val = (Tag)this.jComboBoxWhenResourceMissingType.getSelectedItem();
            subdataset.setWhenResourceMissingType(val.getValue() + "");
        }
        if (this.jButtonOk.getText().equals(I18n.getString("subDatasetDialog.buttonCreate", "Create"))) {
            if (this.getParent() instanceof SubDatasetsDialog) {
                ((SubDatasetsDialog)this.getParent()).addSubDataset(this.getSubDataset());
            }
            this.setSubDataset(subdataset);
            MainFrame.getMainInstance().getActiveReportFrame().getReport().addSubDataset(subdataset);
            return;
        }
        MainFrame.getMainInstance().getActiveReportFrame().getReport().fireReportSubDatasetChangedListenerReportSubDatasetChanged(new ReportSubDatasetChangedEvent(MainFrame.getMainInstance().getActiveReportFrame().getReport(), this.getSubDataset(), 8, 1));
        MainFrame.getMainInstance().getActiveReportFrame().getReport().incrementReportChanges();
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SubDatasetDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        this.jTextFieldName.setText(subDataset.getName());
        this.jTextFieldScriptletClass.setText(subDataset.getScriptletClass());
        this.jTextFieldResourceBoundle.setText(subDataset.getResourceBundleBaseName());
        this.jRTextExpressionAreaFilterExpression.setText(subDataset.getFilterExpression());
        if (subDataset != null) {
            this.jRTextExpressionAreaFilterExpression.setSubDataset(subDataset);
        }
        Misc.setComboboxSelectedTagValue(this.jComboBoxWhenResourceMissingType, subDataset.getWhenResourceMissingType());
        this.jButtonFields.setEnabled(true);
        this.jButtonVariables.setEnabled(true);
        this.jButtonParameters.setEnabled(true);
        this.jButtonQuery.setEnabled(true);
        this.jButtonGroups.setEnabled(true);
        this.jButtonProperties.setEnabled(true);
        this.jButtonOk.setText(I18n.getString("subDatasetDialog.buttonOk", "Ok"));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("subDatasetDialog.buttonCancel", "Cancel"));
        this.jButtonFields.setText(I18n.getString("subDatasetDialog.buttonFields", "Fields"));
        this.jButtonGroups.setText(I18n.getString("subDatasetDialog.buttonGroups", "Groups"));
        this.jButtonOk.setText(I18n.getString("subDatasetDialog.buttonCreate", "Create"));
        this.jButtonParameters.setText(I18n.getString("subDatasetDialog.buttonParameters", "Parameters"));
        this.jButtonProperties.setText(I18n.getString("subDatasetDialog.buttonProperties", "Properties"));
        this.jButtonQuery.setText(I18n.getString("subDatasetDialog.buttonQuery", "Query"));
        this.jButtonVariables.setText(I18n.getString("subDatasetDialog.buttonVariables", "Variables"));
        this.jLabelName.setText(I18n.getString("subDatasetDialog.labelName", "Datasource name"));
        this.jLabelResourceBoundle.setText(I18n.getString("subDatasetDialog.labelResourceBoundle", "Resource Boundle"));
        this.jLabelScriptletClass.setText(I18n.getString("subDatasetDialog.labelScriptletClass", "Scriptlet class"));
        this.jLabelScriptletClass1.setText(I18n.getString("subDatasetDialog.labelScriptletClass1", "Filter expression"));
        this.jLabelWhenResourceMissingType.setText(I18n.getString("subDatasetDialog.labelWhenResourceMissingType", "When resource missing type"));
        ((TitledBorder)this.jPanel4.getBorder()).setTitle(I18n.getString("subDatasetDialog.panelBorder.SubdatasetProperties", "Subdataset properties"));
        this.setTitle(I18n.getString("subDatasetDialog.title", "SubDataset"));
    }

    public void setFocusedExpression(int expID) {
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionAreaFilterExpression);
                break;
            }
            case 2: {
                Misc.selectTextAndFocusArea(this.jTextFieldScriptletClass);
                break;
            }
            case 3: {
                Misc.selectTextAndFocusArea(this.jTextFieldName);
                break;
            }
            case 4: {
                Misc.selectTextAndFocusArea(this.jTextFieldResourceBoundle);
            }
        }
    }
}

