/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class WrappingIconPanel
extends JXPanel {
    JComponent delegate;
    JLabel iconLabel;
    String labelPosition = "Center";
    int iconLabelGap;
    private Border ltorBorder;
    private Border rtolBorder;

    public WrappingIconPanel() {
        this.setOpaque(false);
        this.iconLabel = new JRendererLabel();
        this.iconLabelGap = this.iconLabel.getIconTextGap();
        this.iconLabel.setOpaque(false);
        this.updateIconBorder();
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.iconLabel, "Before");
    }

    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        this.updateIconBorder();
    }

    private void updateIconBorder() {
        if (this.ltorBorder == null) {
            this.ltorBorder = BorderFactory.createEmptyBorder(0, 0, 0, this.iconLabelGap);
            this.rtolBorder = BorderFactory.createEmptyBorder(0, this.iconLabelGap, 0, 0);
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            this.iconLabel.setBorder(this.ltorBorder);
        } else {
            this.iconLabel.setBorder(this.rtolBorder);
        }
    }

    public void setIcon(Icon action) {
        this.iconLabel.setIcon(action);
        this.iconLabel.setText(null);
    }

    public void setComponent(JComponent comp) {
        if (this.delegate != null) {
            this.remove(this.delegate);
        }
        this.delegate = comp;
        this.add((Component)this.delegate, this.labelPosition);
        this.validate();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.iconLabel != null) {
            this.iconLabel.setBackground(bg);
        }
        if (this.delegate != null) {
            this.delegate.setBackground(bg);
        }
    }

    public void setForeground(Color bg) {
        super.setForeground(bg);
        if (this.iconLabel != null) {
            this.iconLabel.setForeground(bg);
        }
        if (this.delegate != null) {
            this.delegate.setForeground(bg);
        }
    }
}

